/*
 * Decompiled with CFR 0.152.
 */
package ttv.migami.jeg.network.message;

import com.mrcrayfish.framework.api.network.MessageContext;
import com.mrcrayfish.framework.api.network.message.PlayMessage;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import ttv.migami.jeg.common.network.ServerPlayHandler;

public class C2SMessageShoot
extends PlayMessage<C2SMessageShoot> {
    private float rotationYaw;
    private float rotationPitch;

    public C2SMessageShoot() {
    }

    public C2SMessageShoot(Player player) {
        this.rotationYaw = player.m_146908_();
        this.rotationPitch = player.m_146909_();
    }

    public C2SMessageShoot(float rotationYaw, float rotationPitch) {
        this.rotationYaw = rotationYaw;
        this.rotationPitch = rotationPitch;
    }

    public void encode(C2SMessageShoot message, FriendlyByteBuf buffer) {
        buffer.writeFloat(message.rotationYaw);
        buffer.writeFloat(message.rotationPitch);
    }

    public C2SMessageShoot decode(FriendlyByteBuf buffer) {
        float rotationYaw = buffer.readFloat();
        float rotationPitch = buffer.readFloat();
        return new C2SMessageShoot(rotationYaw, rotationPitch);
    }

    public void handle(C2SMessageShoot message, MessageContext context) {
        context.execute(() -> {
            ServerPlayer player = context.getPlayer();
            if (player != null) {
                ServerPlayHandler.handleShoot(message, player);
            }
        });
        context.setHandled(true);
    }

    public float getRotationYaw() {
        return this.rotationYaw;
    }

    public float getRotationPitch() {
        return this.rotationPitch;
    }
}

